#ifndef _fma_flags_h_
#define _fma_flags_h_

/*
 * Run-mode flags for FMAs.  This is broken out since there is no telling
 * who might need to include it.
 */

/*
 * FMA flags
 */
#define FMA_FLAG_CAN_ROUTE   0x00000001	/* can compute routes from a map */
#define FMA_FLAG_CAN_VERIFY  0x00000002	/* can patricipate in fabric verify */
#define FMA_FLAG_CAN_PROXY   0x00000004	/* can be a proxy to FMS */
#define FMA_FLAG_NEEDS_PROXY 0x00000008	/* needs to proxy to talk to FMS */
#define FMA_FLAG_HAS_FMS     0x00000010	/* is in contact with FMS */
#define FMA_FLAG_CAN_DO_LAG  0x00000020	/* can perform ethernet link aggr. */
#define FMA_FLAG_LAG_ENABLED 0x00000040	/* currently doing link aggregation */
#define FMA_FLAG_CAN_DISTRIBUTE 0x00000080	/* capable of distributing maps */
 
/* some flag values do not go into the database */
#define FMA_FLAGS_NO_DB_MASK (~(FMA_FLAG_HAS_FMS))

/*
 * Mapper levels can tell us about other guy's FMS connectivity
 */
#define FMA_MAX_MAPPER_LEVEL 100		/* MAX settable mapper level */
#define FMA_PROXY_MAPPER_LEVEL (FMA_MAX_MAPPER_LEVEL+1)
#define FMA_FMS_MAPPER_LEVEL (FMA_PROXY_MAPPER_LEVEL+1)

#endif /* _fma_flags_h_ */
